
<?php $__env->startSection("title"); ?> Settings - Thermal Printer
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>

<div class="page-header">
    <div class="page-header-content header-elements-md-inline">
        <div class="page-title d-flex">
            <h4>
                <span class="font-weight-bold mr-2">Modules</span>
                <i class="icon-circle-right2 mr-2"></i>
                <span class="font-weight-bold mr-2">Thermal Printer</span>
            </h4>
            <a href="#" class="header-elements-toggle text-default d-md-none"><i class="icon-more"></i></a>
        </div>
    </div>
</div>

<div class="content">
    <div class="card">
        <div class="card-body">
        	<form action="<?php echo e(route('thermalprinter.saveSettings')); ?>" method="POST" enctype="multipart/form-data" class="my-3">
        		<legend class="font-weight-semibold text-uppercase font-size-sm">
                    <i class="icon-printer2 mr-1"></i> <?php echo e(__('thermalPrinterLang.printerConnectionSettingsTitle')); ?>

                </legend>

        	    <div class="form-group row">
        	        <label class="col-lg-3 col-form-label"><strong><?php echo e(__('thermalPrinterLang.connectorTypeLabel')); ?>: </strong></label>
        	        <div class="col-lg-9">
        	            <select name="connector_type" class="form-control form-control-lg select">
        	            	<option value="windows" <?php if(!empty($data->connector_type)): ?> <?php if($data->connector_type == "windows"): ?> selected="selected" <?php endif; ?> <?php endif; ?>>Windows</option>
        	            	<option value="cups" <?php if(!empty($data->connector_type)): ?> <?php if($data->connector_type == "cups"): ?> selected="selected" <?php endif; ?> <?php endif; ?>>Linux or MacOS</option>
        	            	<option value="network" <?php if(!empty($data->connector_type)): ?> <?php if($data->connector_type == "network"): ?> selected="selected" <?php endif; ?> <?php endif; ?>>Network</option>
        	            </select>
        	        </div>
        	    </div>
        	    <div class="form-group row">
        	        <label class="col-lg-3 col-form-label"><strong><?php echo e(__('thermalPrinterLang.connectorDescriptorLabel')); ?>: </strong></label>
        	        <div class="col-lg-9">
        	             <input type="text" class="form-control form-control-lg" name="connector_descriptor"
                            required value="<?php if(!empty($data->connector_descriptor)): ?><?php echo e($data->connector_descriptor); ?><?php endif; ?>">
                            <?php if(\Lang::get('thermalPrinterLang.connectorDescriptorHelpMessage') != "NULL"): ?>
                            <span class="text-muted">
                            	<?php echo e((__('thermalPrinterLang.connectorDescriptorHelpMessage'))); ?>

                            </span>
                            <?php else: ?>
                            <span class="text-muted">Enter printer name if your Connector Type is <b>Windows/Linux/MacOS</b></span>
                            <br>
                            <span class="text-muted">Enter the IP address or Samba URI, <b>e.g: smb://192.168.1.12/PrinterName</b> if your Connector Type is <b>Network</b></span><br>
                            <span>
			        	    	<strong class="text-danger">Note: This connection settings is only for Admin. Every Store Owner have their own printer connection settings.</strong>
			        	    </span>
			        	    <?php endif; ?>
        	        </div>
        	    </div>
        	    <div class="form-group row">
        	        <label class="col-lg-3 col-form-label"><strong><?php echo e(__('thermalPrinterLang.printerWidthLabel')); ?>: </strong></label>
        	        <div class="col-lg-9">
        	            <select name="print_width" class="form-control form-control-lg select">
        	            	<option value="3" <?php if(!empty($data->print_width)): ?> <?php if($data->print_width == "3"): ?> selected="selected" <?php endif; ?> <?php endif; ?>>3 Inch (80mm)</option>
        	            	<option value="2" <?php if(!empty($data->print_width)): ?> <?php if($data->print_width == "2"): ?> selected="selected" <?php endif; ?> <?php endif; ?>>2 Inch (58mm)</option>
        	            </select>
        	        </div>
        	    </div>
        	    
        	    <legend class="font-weight-semibold text-uppercase font-size-sm mt-5">
                    <i class="icon-printer4 mr-1"></i> <?php echo e(__('thermalPrinterLang.invoiceSettingsTitle')); ?>

                </legend>

                <div class="form-group row">
                    <label class="col-lg-3 col-form-label"><strong><?php echo e(__('thermalPrinterLang.printKotLabel')); ?>: 
                    </strong></label>
                    <div class="col-lg-9">
                        <div class="checkbox checkbox-switchery mt-2">
                            <label>
                            <input value="true" type="checkbox" class="switchery-primary"
                            <?php if(!empty($data->print_kot)): ?> <?php if($data->print_kot == "true"): ?> checked="checked" <?php endif; ?> <?php endif; ?>
                            name="print_kot">
                            </label>
                        </div>
                    </div>
                </div>

                <?php if(Auth::user()->hasRole('Admin')): ?>
        	    <div class="form-group row">
        	        <label class="col-lg-3 col-form-label"><strong><?php echo e(__('thermalPrinterLang.adminInvoiceTitleLabel')); ?>: </strong></label>
        	        <div class="col-lg-9">
        	             <input type="text" class="form-control form-control-lg" name="invoice_title" value="<?php if(!empty($data->invoice_title)): ?><?php echo e($data->invoice_title); ?><?php endif; ?>">
        	        </div>
        	    </div>

        	    <div class="form-group row">
        	        <label class="col-lg-3 col-form-label"><strong><?php echo e(__('thermalPrinterLang.adminInvoiceSubTitleLabel')); ?>: </strong></label>
        	        <div class="col-lg-9">
        	             <input type="text" class="form-control form-control-lg" name="invoice_subtitle" value="<?php if(!empty($data->invoice_subtitle)): ?><?php echo e($data->invoice_subtitle); ?><?php endif; ?>">
        	        </div>
        	    </div>
        	    <?php endif; ?>

        	    <?php if(Auth::user()->hasRole('Store Owner')): ?>
                <div class="form-group row">
                    <label class="col-lg-3 col-form-label"><strong><?php echo e(__('thermalPrinterLang.automaticPrintingLabel')); ?>: <i class="icon-question3 ml-1" data-popup="tooltip" title="<?php echo e(__('thermalPrinterLang.automaticPrintingInfo')); ?>" data-placement="top"></i></strong></label>
                    <div class="col-lg-9">
                        <select name="automatic_printing" class="form-control form-control-lg select">
                        	<option value="OFF" <?php if(!empty($data->automatic_printing)): ?> <?php if($data->automatic_printing == "OFF"): ?> selected="selected" <?php endif; ?> <?php endif; ?>><?php echo e(__('thermalPrinterLang.automaticPrintingDisabled')); ?></option>
                        	<option value="ONLYINVOICE" <?php if(!empty($data->automatic_printing)): ?> <?php if($data->automatic_printing == "ONLYINVOICE"): ?> selected="selected" <?php endif; ?> <?php endif; ?>><?php echo e(__('thermalPrinterLang.automaticPrintingOnlyInvoice')); ?></option>
                            <option value="BOTH" <?php if(!empty($data->automatic_printing)): ?> <?php if($data->automatic_printing == "BOTH"): ?> selected="selected" <?php endif; ?> <?php endif; ?>><?php echo e(__('thermalPrinterLang.automaticPrintingBothInvoiceAndKot')); ?></option>
                        </select>
                    </div>
                </div>
                <?php endif; ?>


        	    <div class="form-group row">
                    <label class="col-lg-3 col-form-label"><strong><?php echo e(__('thermalPrinterLang.showStoreNameLabel')); ?>: 
                    </strong></label>
                    <div class="col-lg-9">
                        <div class="checkbox checkbox-switchery mt-2">
                            <label>
                            <input value="true" type="checkbox" class="switchery-primary"
                            <?php if(!empty($data->show_store_name)): ?> <?php if($data->show_store_name == "true"): ?> checked="checked" <?php endif; ?> <?php endif; ?>
                            name="show_store_name">
                            </label>
                        </div>
                    </div>
                </div>

                <div class="form-group row">
                    <label class="col-lg-3 col-form-label"><strong><?php echo e(__('thermalPrinterLang.showStoreAddressLabel')); ?>: 
                    </strong></label>
                    <div class="col-lg-9">
                        <div class="checkbox checkbox-switchery mt-2">
                            <label>
                            <input value="true" type="checkbox" class="switchery-primary"
                            <?php if(!empty($data->show_store_address)): ?> <?php if($data->show_store_address == "true"): ?> checked="checked" <?php endif; ?> <?php endif; ?>
                            name="show_store_address">
                            </label>
                        </div>
                    </div>
                </div>

                <div class="form-group row">
                    <label class="col-lg-3 col-form-label"><strong><?php echo e(__('thermalPrinterLang.showOrderIdLabel')); ?>: 
                    </strong></label>
                    <div class="col-lg-9">
                        <div class="checkbox checkbox-switchery mt-2">
                            <label>
                            <input value="true" type="checkbox" class="switchery-primary"
                            <?php if(!empty($data->show_order_id)): ?> <?php if($data->show_order_id == "true"): ?> checked="checked" <?php endif; ?> <?php endif; ?>
                            name="show_order_id">
                            </label>
                        </div>
                    </div>
                </div>

                <div class="form-group row">
                    <label class="col-lg-3 col-form-label"><strong><?php echo e(__('thermalPrinterLang.showDateLabel')); ?>: 
                    </strong></label>
                    <div class="col-lg-9">
                        <div class="checkbox checkbox-switchery mt-2">
                            <label>
                            <input value="true" type="checkbox" class="switchery-primary"
                            <?php if(!empty($data->show_order_date)): ?> <?php if($data->show_order_date == "true"): ?> checked="checked" <?php endif; ?> <?php endif; ?>
                            name="show_order_date">
                            </label>
                        </div>
                    </div>
                </div>

                <div class="form-group row">
        	        <label class="col-lg-3 col-form-label"><strong><?php echo e(__('thermalPrinterLang.orderIdLabel')); ?>: </strong></label>
        	        <div class="col-lg-9">
        	             <input type="text" class="form-control form-control-lg" name="order_id_label" value="<?php if(!empty($data->order_id_label)): ?><?php echo e($data->order_id_label); ?><?php endif; ?>">
        	        </div>
        	    </div>
        	    <div class="form-group row">
        	        <label class="col-lg-3 col-form-label"><strong><?php echo e(__('thermalPrinterLang.orderDateLabel')); ?>: </strong></label>
        	        <div class="col-lg-9">
        	             <input type="text" class="form-control form-control-lg" name="order_date_label" value="<?php if(!empty($data->order_date_label)): ?><?php echo e($data->order_date_label); ?><?php endif; ?>">
        	        </div>
        	    </div>

                <div class="form-group row">
                    <label class="col-lg-3 col-form-label"><strong><?php echo e(__('thermalPrinterLang.customerDetailsTitle')); ?>: </strong></label>
                    <div class="col-lg-9">
                         <input type="text" class="form-control form-control-lg" name="customer_details_title" value="<?php if(!empty($data->customer_details_title)): ?><?php echo e($data->customer_details_title); ?><?php endif; ?>">
                    </div>
                </div>

                <div class="form-group row">
                    <label class="col-lg-3 col-form-label"><strong><?php echo e(__('thermalPrinterLang.showCustomerName')); ?>: 
                    </strong></label>
                    <div class="col-lg-9">
                        <div class="checkbox checkbox-switchery mt-2">
                            <label>
                            <input value="true" type="checkbox" class="switchery-primary"
                            <?php if(!empty($data->show_customer_name)): ?> <?php if($data->show_customer_name == "true"): ?> checked="checked" <?php endif; ?> <?php endif; ?>
                            name="show_customer_name">
                            </label>
                        </div>
                    </div>
                </div>

                <div class="form-group row">
                    <label class="col-lg-3 col-form-label"><strong><?php echo e(__('thermalPrinterLang.showCustomerPhone')); ?>: 
                    </strong></label>
                    <div class="col-lg-9">
                        <div class="checkbox checkbox-switchery mt-2">
                            <label>
                            <input value="true" type="checkbox" class="switchery-primary"
                            <?php if(!empty($data->show_customer_phone)): ?> <?php if($data->show_customer_phone == "true"): ?> checked="checked" <?php endif; ?> <?php endif; ?>
                            name="show_customer_phone">
                            </label>
                        </div>
                    </div>
                </div>

                <div class="form-group row">
                    <label class="col-lg-3 col-form-label"><strong><?php echo e(__('thermalPrinterLang.showDeliveryType')); ?>: 
                    </strong></label>
                    <div class="col-lg-9">
                        <div class="checkbox checkbox-switchery mt-2">
                            <label>
                            <input value="true" type="checkbox" class="switchery-primary"
                            <?php if(!empty($data->show_delivery_type)): ?> <?php if($data->show_delivery_type == "true"): ?> checked="checked" <?php endif; ?> <?php endif; ?>
                            name="show_delivery_type">
                            </label>
                        </div>
                    </div>
                </div>

                <div class="form-group row">
                    <label class="col-lg-3 col-form-label"><strong><?php echo e(__('thermalPrinterLang.deliveryLabel')); ?>: </strong></label>
                    <div class="col-lg-9">
                         <input type="text" class="form-control form-control-lg" name="delivery_label" value="<?php if(!empty($data->delivery_label)): ?><?php echo e($data->delivery_label); ?><?php endif; ?>">
                    </div>
                </div>

                <div class="form-group row">
                    <label class="col-lg-3 col-form-label"><strong><?php echo e(__('thermalPrinterLang.selfPickupLabel')); ?>: </strong></label>
                    <div class="col-lg-9">
                         <input type="text" class="form-control form-control-lg" name="selfpickup_label" value="<?php if(!empty($data->selfpickup_label)): ?><?php echo e($data->selfpickup_label); ?><?php endif; ?>">
                    </div>
                </div>

                <div class="form-group row">
                    <label class="col-lg-3 col-form-label"><strong><?php echo e(__('thermalPrinterLang.showDeliveryAddress')); ?>: 
                    </strong></label>
                    <div class="col-lg-9">
                        <div class="checkbox checkbox-switchery mt-2">
                            <label>
                            <input value="true" type="checkbox" class="switchery-primary"
                            <?php if(!empty($data->show_delivery_address)): ?> <?php if($data->show_delivery_address == "true"): ?> checked="checked" <?php endif; ?> <?php endif; ?>
                            name="show_delivery_address">
                            </label>
                        </div>
                    </div>
                </div>

                <div class="form-group row">
        	        <label class="col-lg-3 col-form-label"><strong><?php echo e(__('thermalPrinterLang.quantityLabel')); ?>: </strong></label>
        	        <div class="col-lg-9">
        	             <input type="text" class="form-control form-control-lg" name="quantity_label" value="<?php if(!empty($data->quantity_label)): ?><?php echo e($data->quantity_label); ?><?php endif; ?>">
        	        </div>
        	    </div>

        	    <div class="form-group row">
        	        <label class="col-lg-3 col-form-label"><strong><?php echo e(__('thermalPrinterLang.itemLabel')); ?>: </strong></label>
        	        <div class="col-lg-9">
        	             <input type="text" class="form-control form-control-lg" name="item_label" value="<?php if(!empty($data->item_label)): ?><?php echo e($data->item_label); ?><?php endif; ?>">
        	        </div>
        	    </div>

        	    <div class="form-group row">
        	        <label class="col-lg-3 col-form-label"><strong><?php echo e(__('thermalPrinterLang.priceLabel')); ?>: </strong></label>
        	        <div class="col-lg-9">
        	             <input type="text" class="form-control form-control-lg" name="price_label" value="<?php if(!empty($data->price_label)): ?><?php echo e($data->price_label); ?><?php endif; ?>">
        	        </div>
        	    </div>

        	    <div class="form-group row">
        	        <label class="col-lg-3 col-form-label"><strong><?php echo e(__('thermalPrinterLang.totalLabel')); ?>: </strong></label>
        	        <div class="col-lg-9">
        	             <input type="text" class="form-control form-control-lg" name="total_label" value="<?php if(!empty($data->total_label)): ?><?php echo e($data->total_label); ?><?php endif; ?>">
        	        </div>
        	    </div>

        	    <div class="form-group row">
        	        <label class="col-lg-3 col-form-label"><strong><?php echo e(__('thermalPrinterLang.storeChargeLabel')); ?>: </strong></label>
        	        <div class="col-lg-9">
        	             <input type="text" class="form-control form-control-lg" name="store_charge_label" value="<?php if(!empty($data->store_charge_label)): ?><?php echo e($data->store_charge_label); ?><?php endif; ?>">
        	        </div>
        	    </div>

        	    <div class="form-group row">
        	        <label class="col-lg-3 col-form-label"><strong><?php echo e(__('thermalPrinterLang.deliveryChargeLabel')); ?>: </strong></label>
        	        <div class="col-lg-9">
        	             <input type="text" class="form-control form-control-lg" name="delivery_charge_label" value="<?php if(!empty($data->delivery_charge_label)): ?><?php echo e($data->delivery_charge_label); ?><?php endif; ?>">
        	        </div>
        	    </div>

        	    <div class="form-group row">
        	        <label class="col-lg-3 col-form-label"><strong><?php echo e(__('thermalPrinterLang.taxLabel')); ?>: </strong></label>
        	        <div class="col-lg-9">
        	             <input type="text" class="form-control form-control-lg" name="tax_label" value="<?php if(!empty($data->tax_label)): ?><?php echo e($data->tax_label); ?><?php endif; ?>">
        	        </div>
        	    </div>

        	    <div class="form-group row">
        	        <label class="col-lg-3 col-form-label"><strong><?php echo e(__('thermalPrinterLang.couponLabel')); ?>: </strong></label>
        	        <div class="col-lg-9">
        	             <input type="text" class="form-control form-control-lg" name="coupon_label" value="<?php if(!empty($data->coupon_label)): ?><?php echo e($data->coupon_label); ?><?php endif; ?>">
        	        </div>
        	    </div>

        	    <?php if(Auth::user()->hasRole('Admin')): ?>
        	    <div class="form-group row">
        	        <label class="col-lg-3 col-form-label"><strong><?php echo e(__('thermalPrinterLang.adminFooterTitleLabel')); ?>: </strong></label>
        	        <div class="col-lg-9">
        	             <input type="text" class="form-control form-control-lg" name="footer_title" value="<?php if(!empty($data->footer_title)): ?><?php echo e($data->footer_title); ?><?php endif; ?>">
        	        </div>
        	    </div>

        	    <div class="form-group row">
        	        <label class="col-lg-3 col-form-label"><strong><?php echo e(__('thermalPrinterLang.adminFooterSubTitleLabel')); ?>: </strong></label>
        	        <div class="col-lg-9">
        	              <textarea class="form-control form-control-lg" name="footer_sub_title"rows="5"
            				placeholder="Hit Enter to break into multiple lines"><?php if(!empty($data->footer_sub_title)): ?><?php echo e($data->footer_sub_title); ?><?php endif; ?></textarea>
        	        </div>
        	    </div>

        	    
        	    <div class="form-group row">
                    <label class="col-lg-3 col-form-label"><strong><?php echo e(__('thermalPrinterLang.adminAllowCustomFooterLabel')); ?>:
                    </strong></label>
                    <div class="col-lg-9">
                        <div class="checkbox checkbox-switchery mt-2">
                            <label>
                            <input value="true" type="checkbox" class="switchery-primary"
                            <?php if(!empty($data->show_custom_store_footer)): ?> <?php if($data->show_custom_store_footer == "true"): ?> checked="checked" <?php endif; ?> <?php endif; ?>
                            name="show_custom_store_footer">
                            </label>
                        </div>
                    </div>
                </div>
                <?php endif; ?>


                <?php if(Auth::user()->hasRole('Store Owner')): ?>
                <?php if(!empty($adminData->show_custom_store_footer)): ?>
        	    <div class="form-group row">
        	        <label class="col-lg-3 col-form-label"><strong><?php echo e(__('thermalPrinterLang.customFooterTitleLabel')); ?>: </strong></label>
        	        <div class="col-lg-9">
        	             <input type="text" class="form-control form-control-lg" name="store_footer_title" value="<?php if(!empty($data->store_footer_title)): ?><?php echo e($data->store_footer_title); ?><?php endif; ?>">
        	        </div>
        	    </div>

        	    <div class="form-group row">
        	        <label class="col-lg-3 col-form-label"><strong><?php echo e(__('thermalPrinterLang.customFooterSubTitleLabel')); ?>: </strong></label>
        	        <div class="col-lg-9">
        	              <textarea class="form-control form-control-lg" name="store_footer_subtitle"rows="5"
            				placeholder="<?php echo e(__('thermalPrinterLang.customFooterSubTitlePlaceholder')); ?>"><?php if(!empty($data->store_footer_subtitle)): ?><?php echo e($data->store_footer_subtitle); ?><?php endif; ?></textarea>
        	        </div>
        	    </div>
        	    <?php endif; ?>

                <?php endif; ?>

        	    <?php echo csrf_field(); ?>
        	    <div class="text-right mt-5">
        	        <button type="submit" class="btn btn-primary btn-labeled btn-labeled-left btn-lg">
        	        <b><i class="icon-database-insert ml-1"></i></b>
        	        <?php echo e(__('thermalPrinterLang.saveSettings')); ?>

        	        </button>
        	    </div>
        	</form>
        </div>
    </div>
</div>
<script>
	"use strict";
	$(function() {
		var elems = document.querySelectorAll('.switchery-primary');
		for (var i = 0; i < elems.length; i++) {
		    var switchery = new Switchery(elems[i], { color: '#8360c3' });
		}
		$('.select').select2({
		    minimumResultsForSearch: -1,
		});
	})
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/development/delivery.betareeq.dev/Modules/ThermalPrinter/Resources/views/settings.blade.php ENDPATH**/ ?>