# Пополнение

Что такое депозит? Депозит это актив, 
которым может пользоваться ваш посетитель для получения 
каких-либо благ.

В данном случае это пополнение кошелька и не более.
В Вашем проекте, кошелек может хранить копейки, центы, доллары 
или, вообще, бублики.

В виртуальной валюте нет ценности.
Она нужна для поощрения пользователя.
Например, начиснять её можно за комментарии, дни рождения итд., 
а тратить на поднятие в поиске или получение звания на вашем ресурсе.

---

## Пользователь

Добавим `HasWallet` trait и `Wallet` interface в модель.

```php
use Bavix\Wallet\Traits\HasWallet;
use Bavix\Wallet\Interfaces\Wallet;

class User extends Model implements Wallet
{
    use HasWallet;
}
```

## Создадим первый депозит

Ищем пользователя:

```php
$user = User::first(); 
```

Так как пользователь имеет `HasWallet` trait, 
он так же имеет `balance`. 
Проверим баланс пользователя.

```php
$user->balance; // int(0)
```

Баланс равен нулю, как мы и ожидали.
Добавим ему 10 бубликов.

```php
$user->deposit(10); 
$user->balance; // int(10)
```

Все верно! На балансе пользователя 10 бубликов.
