<?php

namespace Modules\PaymentOnDeliveryPro\Providers;

use Illuminate\Support\ServiceProvider;
use Illuminate\Database\Eloquent\Factory;

class PaymentOnDeliveryProServiceProvider extends ServiceProvider
{
    /**
     * Boot the application events.
     *
     * @return void
     */
    public function boot()
    {
        $this->registerTranslations();
        $this->registerConfig();
        $this->registerViews();
        $this->registerFactories();
        $this->loadMigrationsFrom(module_path('PaymentOnDeliveryPro', 'Database/Migrations'));
    }

    /**
     * Register the service provider.
     *
     * @return void
     */
    public function register()
    {
        $this->app->register(RouteServiceProvider::class);
    }

    /**
     * Register config.
     *
     * @return void
     */
    protected function registerConfig()
    {
        $this->publishes([
            module_path('PaymentOnDeliveryPro', 'Config/config.php') => config_path('paymentondeliverypro.php'),
        ], 'config');
        $this->mergeConfigFrom(
            module_path('PaymentOnDeliveryPro', 'Config/config.php'), 'paymentondeliverypro'
        );
    }

    /**
     * Register views.
     *
     * @return void
     */
    public function registerViews()
    {
        $viewPath = resource_path('views/modules/paymentondeliverypro');

        $sourcePath = module_path('PaymentOnDeliveryPro', 'Resources/views');

        $this->publishes([
            $sourcePath => $viewPath
        ],'views');

        $this->loadViewsFrom(array_merge(array_map(function ($path) {
            return $path . '/modules/paymentondeliverypro';
        }, \Config::get('view.paths')), [$sourcePath]), 'paymentondeliverypro');
    }

    /**
     * Register translations.
     *
     * @return void
     */
    public function registerTranslations()
    {
        $langPath = resource_path('lang/modules/paymentondeliverypro');

        if (is_dir($langPath)) {
            $this->loadTranslationsFrom($langPath, 'paymentondeliverypro');
        } else {
            $this->loadTranslationsFrom(module_path('PaymentOnDeliveryPro', 'Resources/lang'), 'paymentondeliverypro');
        }
    }

    /**
     * Register an additional directory of factories.
     *
     * @return void
     */
    public function registerFactories()
    {
        if (! app()->environment('production') && $this->app->runningInConsole()) {
            app(Factory::class)->load(module_path('PaymentOnDeliveryPro', 'Database/factories'));
        }
    }

    /**
     * Get the services provided by the provider.
     *
     * @return array
     */
    public function provides()
    {
        return [];
    }
}
