<?php

namespace App;

use App\SmsOtp;
use App\User;
use Exception;
use Illuminate\Http\Request;
use Ixudra\Curl\Facades\Curl;
use JWTAuth;
use JWTAuthException;
use Session;
use Twilio\Rest\Client;

class Sms
{

    /**
     * @param $actionType
     * @param $phone
     * @param $otp
     * @param null $message
     * @return mixed
     */
    public function processSmsAction($actionType, $phone, $otp = null, $message = null, $smsForDelivery = null)
    {
        // Selects Default Gateway
        $gateway = config('appSettings.defaultSmsGateway');

        switch ($gateway) {

            case '1':
                try {
                    $response = $this->msg91($actionType, $phone, $otp, $message, $smsForDelivery);
                } catch (Exception $e) {
                    $response = [
                        'success' => false,
                        'type' => 'MSG91',
                    ];
                }

                break;

            case '2':
                try {
                    $response = $this->twilio($actionType, $phone, $otp, $message);
                } catch (Exception $e) {
                    $response = [
                        'success' => false,
                        'type' => 'TWILIO',
                    ];
                }

                break;
            case 'other':
				try {
					$response = $this->otherSMSService($actionType, $phone, $otp, $message, $smsForDelivery);
					// dd('response', $response);
				} catch (Exception $e) {
					// dd('catch', $e);
					$response = [
						'success' => false,
						'type' => 'OTHER',
					];
				}
				break;
			default: break;
        }
        return $response;

    }

    /**
     * @param $actionType
     * @param $phone
     * @param $otp
     * @param $message
     * @return mixed
     */
    private function msg91($actionType, $phone, $otp, $message, $smsForDelivery = null)
    {
        $authkey = config('appSettings.msg91AuthKey');
        $sender_id = config('appSettings.msg91SenderId');

        switch ($actionType) {

            case 'OTP':
                $otp = rand(111111, 999999);
                $message = config('appSettings.otpMessage') . ' ' . $otp;
                $this->saveOtp($phone, $otp);

                $msg_dlt_template_id = config('appSettings.msg91OtpDltTemplateId');
                if ($msg_dlt_template_id == null) {
                    $curlPost = "{ \"sender\": \"$sender_id\", \"route\": \"4\", \"sms\": [ { \"message\": \"$message\", \"to\": [ \"$phone\" ] } ] }";
                } else {
                    $curlPost = "{ \"DLT_TE_ID\": \"$msg_dlt_template_id\", \"sender\": \"$sender_id\", \"route\": \"4\", \"sms\": [ { \"message\": \"$message\", \"to\": [ \"$phone\" ] } ] }";
                }

                break;

            case 'VERIFY':
                $response = $this->verifyOtp($phone, $otp);
                return $response;
                break;

            case 'OD_NOTIFY':

                if ($smsForDelivery) {
                    $msg_dlt_template_id = config('appSettings.msg91NewOrderDeliveryDltTemplateId');
                } else {
                    $msg_dlt_template_id = config('appSettings.msg91NewOrderDltTemplateId');
                }

                if ($msg_dlt_template_id == null) {
                    $curlPost = "{ \"sender\": \"$sender_id\", \"route\": \"4\", \"sms\": [ { \"message\": \"$message\", \"to\": [ \"$phone\" ] } ] }";
                } else {
                    $curlPost = "{ \"DLT_TE_ID\": \"$msg_dlt_template_id\", \"sender\": \"$sender_id\", \"route\": \"4\", \"sms\": [ { \"message\": \"$message\", \"to\": [ \"$phone\" ] } ] }";
                }

                break;

        }

        $phone = preg_replace('/[^0-9]/', '', $phone);
        $curl = curl_init();

        curl_setopt_array($curl, array(
            CURLOPT_URL => 'https://api.msg91.com/api/v2/sendsms',
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 30,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'POST',
            CURLOPT_POSTFIELDS => $curlPost,
            CURLOPT_SSL_VERIFYHOST => 0,
            CURLOPT_SSL_VERIFYPEER => 0,
            CURLOPT_HTTPHEADER => array(
                "authkey: $authkey",
                'content-type: application/json',
            ),
        ));

        $response = curl_exec($curl);
        $err = curl_error($curl);
        curl_close($curl);

        if ($err) {
            return false;
        } else {
            return true;
        }

    }

    /**
     * @param $actionType
     * @param $phone
     * @param $otp
     * @param $message
     * @return mixed
     */
    private function twilio($actionType, $phone, $otp, $message)
    {
        $sid = config('appSettings.twilioSid');
        $token = config('appSettings.twilioAccessToken');
        $from = config('appSettings.twilioFromPhone');

        switch ($actionType) {

            case 'OTP':
                $otp = rand(111111, 999999);
                $message = config('appSettings.otpMessage') . ' ' . $otp;
                $this->saveOtp($phone, $otp);

                break;

            case 'VERIFY':
                $response = $this->verifyOtp($phone, $otp);
                return $response;
                break;

            case 'OD_NOTIFY':
                // Do Nothing Just Send
                break;
        }
        // Send Api Request

        $twilio = new Client($sid, $token);

        try {
            $twilio->messages->create(
                // Where to send a text message (your cell phone?)
                $phone,
                array(
                    'From' => $from,
                    'body' => $message,
                )
            );
            return true;
        } catch (Exception $e) {
            \Log::error($e->getMessage());
            throw new Exception('Twilio Error');
        } catch (\Twilio\Rest\RestException $e) {
            \Log::error($e);
            throw new Exception('Twilio Error');
        } catch (\Twilio\Exceptions\RestException $e) {
            \Log::error($e);
            throw new Exception('Twilio Error');
        }
    }
    
    private function otherSMSService($actionType, $phone, $otp, $message, $smsForDelivery = null) {
		// $phone = preg_replace("/[^0-9 ]/", '', $phone);
		
        // Use this for Removing the complete country code
        // $phone = preg_replace("/^\+?91/", '', $phone);
		
		// Use this for Removing the + sign from country code
        $phone = preg_replace("/^\+/", '', $phone);

		$data = config('appSettings');
		$smsTemplateId;

		switch($actionType) {
			case 'OTP':
				$otp = rand(111111, 999999);
				$message = config('appSettings.otpMessage') . ' ' . $otp;
				$this->saveOtp($phone, $otp);

				$smsTemplateId = config('appSettings.otherSMSOtpDltTemplateId');
				break;
			case 'VERIFY':
				$response = $this->verifyOtp($phone, $otp);
				return $response;
				break;
			case 'OD_NOTIFY':
				if($smsForDelivery) {
					$smsTemplateId = config('appSettings.otherSMSNewOrderDeliveryDltTemplateId');
				} else {
					$smsTemplateId = config('appSettings.otherSMSNewOrderDltTemplateId');
				}
				break;
			default: break;
		}

		$requestData = [
			$data['otherSMSSendParameterName'] => $phone,
			$data['otherSMSMessageParameterName'] => $message,
		];

		if(!empty($smsTemplateId)) $requestData['DLT_TE_ID'] = $smsTemplateId;
		// if(!empty($smsTemplateId)) $requestData['template_id'] = $smsTemplateId;
		
		if(!empty($data['otherSMSParameter0Name'])) $requestData[$data['otherSMSParameter0Name']] = $data['otherSMSParameter0Value'];
		if(!empty($data['otherSMSParameter1Name'])) $requestData[$data['otherSMSParameter1Name']] = $data['otherSMSParameter1Value'];
		if(!empty($data['otherSMSParameter2Name'])) $requestData[$data['otherSMSParameter2Name']] = $data['otherSMSParameter2Value'];
		if(!empty($data['otherSMSParameter3Name'])) $requestData[$data['otherSMSParameter3Name']] = $data['otherSMSParameter3Value'];
		if(!empty($data['otherSMSParameter4Name'])) $requestData[$data['otherSMSParameter4Name']] = $data['otherSMSParameter4Value'];
		if(!empty($data['otherSMSParameter5Name'])) $requestData[$data['otherSMSParameter5Name']] = $data['otherSMSParameter5Value'];
		if(!empty($data['otherSMSParameter6Name'])) $requestData[$data['otherSMSParameter6Name']] = $data['otherSMSParameter6Value'];
		if(!empty($data['otherSMSParameter7Name'])) $requestData[$data['otherSMSParameter7Name']] = $data['otherSMSParameter7Value'];
		if(!empty($data['otherSMSParameter8Name'])) $requestData[$data['otherSMSParameter8Name']] = $data['otherSMSParameter8Value'];
		if(!empty($data['otherSMSParameter9Name'])) $requestData[$data['otherSMSParameter9Name']] = $data['otherSMSParameter9Value'];

		$url = $data['otherSMSURL'];
		if(empty($url)) return false;

		$requestType = $data['otherSMSRequestType'];

		$headers = [];
		if(!empty($data['otherSMSHeader0Name'])) $headers[$data['otherSMSHeader0Name']] = $data['otherSMSHeader0Value'];
		if(!empty($data['otherSMSHeader1Name'])) $headers[$data['otherSMSHeader1Name']] = $data['otherSMSHeader1Value'];
		if(!empty($data['otherSMSHeader2Name'])) $headers[$data['otherSMSHeader2Name']] = $data['otherSMSHeader2Value'];
		if(!empty($data['otherSMSHeader3Name'])) $headers[$data['otherSMSHeader3Name']] = $data['otherSMSHeader3Value'];

		// dd($url, $requestData, $requestType);
		
		try {
			$curlQuery = Curl::to($url)->withHeaders($headers)->withData($requestData);
			$response = $requestType === 'GET' ? $curlQuery->get() : $curlQuery->post();
			return true;
		} catch (\Exception $e) {
			throw $e;
		}
	}
	
    /**
     * @param $phone
     * @param $otp
     */
    private function saveOtp($phone, $otp)
	{
		$phone = $this->formatPhoneNumber($phone);

		$otpTable = SmsOtp::where('phone', $phone)->first();

		if($otpTable) {
			//phone exists, just update the otp
			$otpTable->otp = $otp;
			$otpTable->save();
			# code...
		} else {
			//create new entry
			$otpTable = new SmsOtp();
			$otpTable->phone = $phone;
			$otpTable->otp = $otp;
			$otpTable->save();
		}
		// dd($phone);
	}

	/**
	 * @param $phone
	 * @param $otp
	 */
	private function verifyOtp($phone, $otp)
	{
		// dd($otp);
		$phone = $this->formatPhoneNumber($phone);
		$otpTable = SmsOtp::where('phone', $phone)->first();

		if($otpTable) {
			if($otpTable->otp == $otp) {

				$response = [
					'valid_otp' => true,
				];

			} else {
				$response = [
					'valid_otp' => false,
				];
			}
		} else {
			$response = [
				'valid_otp' => false,
			];

		}
		return $response;
	}

	private function formatPhoneNumber($phone) {
		return preg_replace('/^(?:\+?966|0)?/', '+966', $phone);
	}
}
