
<?php $__env->startSection("title"); ?> <?php echo e(__('storeDashboard.opTitle')); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
<div class="page-header">
    <div class="page-header-content header-elements-md-inline">
        <div class="page-title d-flex">
            <h4>
                <span class="font-weight-bold mr-2"><?php echo e(__('storeDashboard.total')); ?></span>
                <i class="icon-circle-right2 mr-2"></i>
                <span class="font-weight-bold mr-2"><?php echo e($count); ?></span>
            </h4>
            <a href="#" class="header-elements-toggle text-default d-md-none"><i class="icon-more"></i></a>
        </div>
    </div>
</div>
<div class="content">
    <form action="<?php echo e(route('restaurant.post.searchOrders')); ?>" method="GET">
        <div class="form-group form-group-feedback form-group-feedback-right search-box">
            <input type="text" class="form-control form-control-lg search-input"
                placeholder="<?php echo e(__('storeDashboard.opSearchPh')); ?>" name="query">
            <div class="form-control-feedback form-control-feedback-lg">
                <i class="icon-search4"></i>
            </div>
        </div>
        <?php echo csrf_field(); ?>
    </form>
    <div class="card">
        <div class="card-body">
            <div class="table-responsive">
                <table class="table">
                    <thead>
                        <tr>
                            <th><?php echo e(__('storeDashboard.opTableOrderId')); ?></th>
                            <th><?php echo e(__('storeDashboard.opTableRestName')); ?></th>
                            <th><?php echo e(__('storeDashboard.opTableStatus')); ?></th>
                            <th><?php echo e(__('storeDashboard.opPaymentMode')); ?></th>
                            <th><?php echo e(__('storeDashboard.opTableTotal')); ?></th>
                            <th><?php echo e(__('storeDashboard.opTableCoupon')); ?></th>
                            <th><?php echo e(__('storeDashboard.opTableOrderPlacedAt')); ?></th>
                            <th class="text-center" style="width: 10%;"><i class="
                                icon-circle-down2"></i></th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $orders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $order): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td><span style="font-size: 0.7rem; font-weight: 700;">#<?php echo e(substr ($order->unique_order_id, -9)); ?></span></td>
                            <td><?php echo e($order->restaurant->name); ?></td>
                            <td>
                                <span class="badge badge-flat border-grey-800 text-default text-capitalize text-left">
                                    <?php if($order->orderstatus_id == 1): ?> <?php echo e(__('storeDashboard.opOrderStatus1')); ?> <?php endif; ?>
                                    <?php if($order->orderstatus_id == 2): ?> <?php echo e(__('storeDashboard.opOrderStatus2')); ?> <?php endif; ?>
                                    <?php if($order->orderstatus_id == 3): ?> <?php echo e(__('storeDashboard.opOrderStatus3')); ?> <?php endif; ?>
                                    <?php if($order->orderstatus_id == 4): ?> <?php echo e(__('storeDashboard.opOrderStatus4')); ?> <?php endif; ?>
                                    <?php if($order->orderstatus_id == 5): ?> <?php echo e(__('storeDashboard.opOrderStatus5')); ?> <?php endif; ?>
                                    <?php if($order->orderstatus_id == 6): ?> <?php echo e(__('storeDashboard.opOrderStatus6')); ?> <?php endif; ?>
                                    <?php if($order->orderstatus_id == 7): ?> <?php echo e(__('storeDashboard.opOrderStatus7')); ?> <?php endif; ?>
                                    <?php if($order->orderstatus_id == 10): ?> <?php echo e(__('storeDashboard.opOrderStatus10')); ?> <?php endif; ?>
                                    <?php if($order->orderstatus_id == 11): ?> <?php echo e(__('storeDashboard.opOrderStatus11')); ?> <?php endif; ?>

                                    <?php if($order->accept_delivery !== null): ?>
                                    <?php if($order->orderstatus_id > 2 && $order->orderstatus_id  < 6): ?>
                                    <?php echo e(__('storeDashboard.opDeliveryBy')); ?>: <b><?php echo e($order->accept_delivery->user->name); ?></b>
                                    <?php endif; ?>
                                    <?php endif; ?>
                                </span>
                            </td>
                            <td>
                                <span class="badge badge-flat border-grey-800 text-default text-capitalize">
                                <?php echo e($order->payment_mode); ?>

                                </span>
                            </td>
                            <?php
                               if(!is_null($order->tip_amount)) {
                                   $total = $order->total - $order->tip_amount;
                               } else {
                                   $total = $order->total;
                               }
                             ?>
                            <td><?php echo e(config('appSettings.currencyFormat')); ?> <?php echo e($total); ?></td>
                            <td>
                                <?php if($order->coupon_name == NULL): ?> <?php echo e(__('storeDashboard.opNone')); ?> <?php else: ?>
                                <span class="badge badge-flat border-grey-800 text-default text-capitalize">
                                <?php echo e($order->coupon_name); ?>

                                </span>
                                <?php endif; ?>
                            </td>
                            <td>
                                <span  data-popup="tooltip" data-placement="bottom" title="<?php echo e($order->created_at->format('Y-m-d  - h:i A')); ?>">
                                <?php echo e($order->created_at->diffForHumans()); ?>

                                </span>
                            </td>
                            <td class="text-center">
                                <a href="<?php echo e(route('restaurant.viewOrder', $order->unique_order_id)); ?>"
                                    class="btn btn-sm btn-primary"> <?php echo e(__('storeDashboard.opView')); ?></a>
                            </td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
                <div class="mt-3">
                    <?php echo e($orders->appends($_GET)->links()); ?>

                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/betareeq/delivery.betareeq.com/resources/views/restaurantowner/orders.blade.php ENDPATH**/ ?>