
<?php $__env->startSection("title"); ?> Translations - Dashboard
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
<style>
    .btn-success:hover {
    color: #fff;
    background-color: #4caf50;
    }
    .cursor-disabled {
    cursor: not-allowed;
    }
</style>
<div class="page-header">
    <div class="page-header-content header-elements-md-inline">
        <div class="page-title d-flex">
            <h4>
                <span class="font-weight-bold mr-2">TOTAL</span>
                <i class="icon-circle-right2 mr-2"></i>
                <span class="font-weight-bold mr-2"><?php echo e($count); ?> Languages</span>
            </h4>
            <a href="#" class="header-elements-toggle text-default d-md-none"><i class="icon-more"></i></a>
        </div>
        <div class="header-elements d-none py-0 mb-3 mb-md-0">
            <div class="breadcrumb">
                <a href="<?php echo e(route('admin.newTranslation')); ?>" class="btn btn-secondary btn-labeled btn-labeled-left">
                <b><i class="icon-plus2"></i></b>
                Add New Langauage
                </a>
            </div>
        </div>
    </div>
</div>
<div class="content">
    <div class="card">
        <div class="card-body">
            <div class="table-responsive">
                <table class="table">
                    <thead>
                        <tr>
                            <th>Language Name</th>
                            <th>Status</th>
                            <th>Created At</th>
                            <th>Updated At</th>
                            <th class="text-center"><i class="
                                icon-circle-down2"></i></th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $translations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $translation): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td><?php echo e($translation->language_name); ?></td>
                            <td>
                                <?php if($translation->is_active): ?>
                                <span class="badge badge-flat border-grey-800 text-success text-capitalize">
                                ACTIVE 
                                </span>
                                <?php else: ?>
                                <span class="badge badge-flat border-grey-800 text-danger text-capitalize">
                                INACTIVE 
                                </span>
                                <?php endif; ?>
                                <?php if($translation->is_default): ?>
                                <span class="badge badge-flat bg-success text-white text-capitalize"> DEFAULT </span>
                                <?php endif; ?>
                            </td>
                            <td><?php echo e($translation->created_at->diffForHumans()); ?></td>
                            <td><?php echo e($translation->updated_at->diffForHumans()); ?></td>
                            <td class="text-center">
                                <div class="btn-group btn-group-justified justify-content-center">
                                    <a href="<?php echo e(route('admin.editTranslation', $translation->id)); ?>"
                                        class="btn btn-sm btn-primary"> Edit</a>

                                    <?php if(!$translation->is_default): ?>
                                        <?php if($translation->is_active): ?>
                                        <a href="<?php echo e(route('admin.disableTranslation', $translation->id)); ?>" class="btn btn-sm btn-primary ml-1" data-popup="tooltip" title="Disable Translation" data-placement="bottom"> <i class="icon-switch2"></i> </a>
                                        <?php else: ?>
                                        <a href="<?php echo e(route('admin.disableTranslation', $translation->id)); ?>" class="btn btn-sm btn-danger ml-1" data-popup="tooltip" title="Enable Translation" data-placement="bottom"> <i class="icon-switch2"></i> </a>
                                        <?php endif; ?>
                                    <?php endif; ?>

                                    <a href="<?php if($translation->is_default): ?> javascript:void(0) <?php else: ?> <?php echo e(route('admin.makeDefaultLanguage', $translation->id)); ?> <?php endif; ?>" class="btn btn-sm btn-dark ml-1 <?php if($translation->is_default): ?> badge-success btn-success cursor-disabled <?php endif; ?>" <?php if(!$translation->is_default): ?> data-popup="tooltip" title="Make <?php echo e($translation->language_name); ?> as Default Language" data-placement="bottom" <?php endif; ?>> <i class="icon-checkmark4"></i> </a>
                                </div>
                            </td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/betareeq/delivery.betareeq.com/resources/views/admin/translations.blade.php ENDPATH**/ ?>