<?php $__env->startSection("title"); ?>
Dashboard
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
<style>
    .chart-container {
    margin-top: 5rem;
    overflow: hidden;
    }
    .chart-container.has-scroll {
    overflow: hidden;
    }
</style>
<div class="content mb-5">
    <div class="row mt-4">
        <div class="col-6 col-xl-3 mb-2 mt-2">
            <div class="col-xl-12 dashboard-display p-3">
                <a class="block block-link-shadow text-left text-default" href="<?php echo e(route('admin.orders')); ?>">
                    <div class="block-content block-content-full clearfix">
                        <div class="float-right mt-10 d-none d-sm-block">
                            <i class="dashboard-display-icon icon-basket"></i>
                        </div>
                        <div class="dashboard-display-number"><?php echo e($displaySales); ?></div>
                        <div class="font-size-sm text-uppercase text-muted">Orders</div>
                    </div>
                </a>
            </div>
        </div>
        <div class="col-6 col-xl-3 mb-2 mt-2">
            <div class="col-xl-12 dashboard-display p-3">
                <a class="block block-link-shadow text-left text-default" href="<?php echo e(route('admin.users')); ?>">
                    <div class="block-content block-content-full clearfix">
                        <div class="float-right mt-10 d-none d-sm-block">
                            <i class="dashboard-display-icon icon-users4"></i>
                        </div>
                        <div class="dashboard-display-number"><?php echo e($displayUsers); ?></div>
                        <div class="font-size-sm text-uppercase text-muted">Users</div>
                    </div>
                </a>
            </div>
        </div>
        <div class="col-6 col-xl-3 mb-2 mt-2">
            <div class="col-xl-12 dashboard-display p-3">
                <a class="block block-link-shadow text-left text-default" href="<?php echo e(route('admin.restaurants')); ?>">
                    <div class="block-content block-content-full clearfix">
                        <div class="float-right mt-10 d-none d-sm-block">
                            <i class="dashboard-display-icon icon-store2"></i>
                        </div>
                        <div class="dashboard-display-number"><?php echo e($displayRestaurants); ?></div>
                        <div class="font-size-sm text-uppercase text-muted">Stores</div>
                    </div>
                </a>
            </div>
        </div>
        <div class="col-6 col-xl-3 mb-2 mt-2">
            <div class="col-xl-12 dashboard-display p-3">
                <a class="block block-link-shadow text-left text-default" href="javascript:void(0)">
                    <div class="block-content block-content-full clearfix">
                        <div class="float-right mt-10 d-none d-sm-block">
                            <i class="dashboard-display-icon icon-coin-dollar"></i>
                        </div>
                        <div class="dashboard-display-number"><?php echo e(config('appSettings.currencyFormat')); ?> <?php echo e($displayEarnings); ?></div>
                        <div class="font-size-sm text-uppercase text-muted">Earnings</div>
                    </div>
                </a>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-xl-6">
            <h4 class="panel-title pl-1 mt-4"><strong>Recent Orders <a href="<?php echo e(route('admin.orders')); ?>" class="btn btn-default float-right">View All</a></strong></h4>
            <div class="mt-2" style="min-height: 30rem;">
                <?php $__currentLoopData = $orders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $order): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="recent-order-card p-2">
                    <a href="<?php echo e(route('admin.viewOrder', $order->unique_order_id)); ?>">
                        <div class="float-right text-right">
                            <span class="badge order-badge badge-color-<?php echo e($order->orderstatus_id); ?> border-grey-800">
                            <?php if($order->orderstatus_id == 1): ?> Order Placed <?php endif; ?>
                            <?php if($order->orderstatus_id == 2): ?> Order Accepted <?php endif; ?>
                            <?php if($order->orderstatus_id == 3): ?> Delivery Assigned <?php endif; ?>
                            <?php if($order->orderstatus_id == 4): ?> Picked Up <?php endif; ?>
                            <?php if($order->orderstatus_id == 5): ?> Completed <?php endif; ?>
                            <?php if($order->orderstatus_id == 6): ?> Canceled <?php endif; ?>
                            <?php if($order->orderstatus_id == 7): ?> Ready for Pickup <?php endif; ?>
                            <?php if($order->orderstatus_id == 8): ?> Awaiting Payment <?php endif; ?>
                            <?php if($order->orderstatus_id == 9): ?> Payment Failed <?php endif; ?>
                            <?php if($order->orderstatus_id == 10): ?> Scheduled Order <?php endif; ?>
                            <?php if($order->orderstatus_id == 11): ?> Confirmed Order <?php endif; ?>
                            </span>
                            <br>
                            <?php if($agent->isDesktop()): ?>
                            <?php if($order->orderstatus_id == 5): ?>
                            <p class="order-dashboard-time min-fit-content mt-1"><b>Completed in: </b><?php echo e(timeStrampDiffFormatted($order->created_at, $order->updated_at)); ?></p>
                            <?php elseif($order->orderstatus_id == 6): ?>
                            <p class="order-dashboard-time min-fit-content mt-1"><b>Cancelled in: </b> <?php echo e(timeStrampDiffFormatted($order->created_at, $order->updated_at)); ?></p>
                            <?php else: ?>
                            <p class="liveTimer mt-1 text-center min-fit-content order-dashboard-time" title="<?php echo e($order->created_at); ?>"><i class="icon-spinner10 spinner position-left"></i></p>
                            <?php endif; ?>
                            <?php endif; ?>
                        </div>
                        <div class="d-flex justify-content-start">
                            <div>
                                <img src="<?php echo e(substr(url("/"), 0, strrpos(url("/"), '/'))); ?><?php echo e($order->restaurant->image); ?>"
                                alt="<?php echo e($order->restaurant->name); ?>" height="70" width="70"
                                style="border-radius: 8px;">
                            </div>
                            <div class="ml-2">
                                <span><b><?php echo e($order->restaurant->name); ?></b></span>
                                <br>
                                <span>#<?php echo e(substr ($order->unique_order_id, -9)); ?></span>
                                <br>
                                <span><strong><?php echo e(config('appSettings.currencyFormat')); ?><?php echo e($order->total); ?></strong></span>
                            </div>
                        </div>
                        <?php if($agent->isMobile()): ?>
                        <div class="mt-2">
                            <?php if($order->orderstatus_id == 5): ?>
                            <p class="order-dashboard-time min-fit-content mt-1"><b>Completed in: </b><?php echo e(timeStrampDiffFormatted($order->created_at, $order->updated_at)); ?></p>
                            <?php elseif($order->orderstatus_id == 6): ?>
                            <p class="order-dashboard-time min-fit-content mt-1"><b>Cancelled in: </b> <?php echo e(timeStrampDiffFormatted($order->created_at, $order->updated_at)); ?></p>
                            <?php else: ?>
                            <p class="liveTimer mt-1 text-center min-fit-content order-dashboard-time" title="<?php echo e($order->created_at); ?>"><i class="icon-spinner10 spinner position-left"></i></p>
                            <?php endif; ?>
                        </div>
                        <?php endif; ?>
                    </a>
                </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </div>
        <div class="col-xl-6 d-none d-md-block">
            <div class="panel panel-flat">
                <div class="panel-body">
                    <?php if($ifAnyOrders): ?>
                    <div class="chart-container has-scroll">
                        <div class="chart has-fixed-height has-minimum-width" id="basic_donut"></div>
                    </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
    <div class="row">
        <div class="col-xl-12">
            <h4 class="panel-title pl-1 mt-4"><strong>New Users <a href="<?php echo e(route('admin.users')); ?>" class="btn btn-default float-right">View All</a></strong></h4>
            <div class="mt-2">
                <div class="row">
                    <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="col-md-4">
                        <div class="col-md-12 new-users p-2">
                            <a href="<?php echo e(route('admin.get.editUser', $user->id)); ?>">
                                <div class="float-right">
                                    <?php $__currentLoopData = $user->roles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $role): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <span class="badge badge-flat border-grey-800 text-default text-capitalize">
                                    <?php echo e($role->name); ?>

                                    </span>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </div>
                                <div class="d-flex justify-content-start">
                                    <div class="first-letter-icon custom-bg-<?php echo e(rand(1,8)); ?>">
                                        <?php echo e(returnAcronym($user->name)); ?>

                                    </div>
                                    <div class="ml-2">
                                        <span> <?php echo e($user->name); ?></span><br>
                                        <span><?php echo e($user->email); ?></span><br>
                                        <span><?php echo e($user->created_at->diffForHumans()); ?></span>
                                    </div>
                                </div>
                            </a>
                        </div>
                    </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>
        </div>
    </div>
</div>
<script>
    $(function () {
    
        timer = setInterval(updateClock, 1000);
    
        var newDate = new Date();
        var newStamp = newDate.getTime();
    
        var timer; 
    
        function updateClock() {
    
            $('.liveTimer').each(function(index, el) {
                var orderCreatedData = $(this).attr("title");
                var startDateTime = new Date(orderCreatedData); 
                var startStamp = startDateTime.getTime();
            
    
                newDate = new Date();
                newStamp = newDate.getTime();
                var diff = Math.round((newStamp-startStamp)/1000);
                
                var d = Math.floor(diff/(24*60*60));
                diff = diff-(d*24*60*60);
                var h = Math.floor(diff/(60*60));
                diff = diff-(h*60*60);
                var m = Math.floor(diff/(60));
                diff = diff-(m*60);
                var s = diff;
                var checkDay = d > 0 ? true : false;
                var checkHour = h > 0 ? true : false;
                var checkMin = m > 0 ? true : false;
                var checkSec = s > 0 ? true : false;
                var formattedTime = checkDay ? d+ " day" : "";
                formattedTime += checkHour ? " " +h+ " hour" : "";
                formattedTime += checkMin ? " " +m+ " minute" : "";
                formattedTime += checkSec ? " " +s+ " second" : "";
    
                $(this).text(formattedTime);
            });
        }
    
        require.config({
            paths: {
                echarts: '<?php echo e(substr(url("/"), 0, strrpos(url("/"), '/'))); ?>/assets/backend/global_assets/js/plugins/visualization/echarts'
            }
        });
    
        require(
            [
                'echarts',
                'echarts/theme/limitless',
                'echarts/chart/pie',
                'echarts/chart/funnel',
            ],
    
            function (ec, limitless) {
    
                var basic_donut = ec.init(document.getElementById('basic_donut'), limitless);
              
                basic_donut_options = {
    
                    // Add title
                    title: {
                        text: 'Overview Of Order Statuses',
                        subtext: 'Of all orders till <?php echo e($todaysDate); ?>',
                        x: 'center'
                    },
    
                    // Add legend
                    legend: {
                        show: false,
                        orient: 'vertical',
                        x: 'left',
                        data: <?php echo $orderStatusesName; ?>

                    },
    
                    // Display toolbox
                    toolbox: {
                        show: false,
                    },
    
                    // Enable drag recalculate
                    calculable: false,
    
                    // Add series
                    series: [
                        {
                            name: 'Orders',
                            type: 'pie',
                            radius: ['50%', '70%'],
                            center: ['50%', '58%'],
                            itemStyle: {
                                normal: {
                                    label: {
                                        show: true
                                    },
                                    labelLine: {
                                        show: true
                                    }
                                },
                                emphasis: {
                                    label: {
                                        show: true,
                                        formatter: '{b}' + '\n\n' + '{c} ({d}%)',
                                        position: 'center',
                                        textStyle: {
                                            fontSize: '17',
                                            fontWeight: '500'
                                        }
                                    }
                                }
                            },
    
                            data: <?php echo $orderStatusesData; ?> 
                        }
                    ]
                };
    
                basic_donut.setOption(basic_donut_options);
    
                 window.onresize = function () {
                    setTimeout(function (){
                        basic_donut.resize();
                    }, 200);
                }
    
            }
        );
    });
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/betareeq/delivery.betareeq.com/resources/views/admin/dashboard.blade.php ENDPATH**/ ?>