@extends('admin.layouts.master')
@section("title")
Ver Repartidores en Mapa | Dashboard
@endsection
@section('content')
<div class="page-header">
    <div class="page-header-content header-elements-md-inline">
        <div class="page-title d-flex">
            <h4><i class="icon-circle-right2 mr-2"></i>
                <span class="font-weight-bold">Delivery Guys</span>
            </h4>
            <a href="#" class="header-elements-toggle text-default d-md-none"><i class="icon-more"></i></a>
        </div>
    </div>
</div>
{{-- dd($users) --}}
@foreach($users as $user)
    @if(count($user->orders_running) > 0)
        {{-- dd($user) --}},
    @endif
@endforeach
<div class="content">
    <script>
    
        var data = {
            "num_rows": '{{ count($users) }}',
            "markers": [
                @foreach($users as $user)
                    @if($user->del_lat != null && $user->del_lng != null)
                        {
                            "name": '{{$user->name}}',
                            "email": '{{$user->email}}',
                            "phone": '{{$user->phone}}',
                            "deliveryStatus": '{{ $user->delivery_status }}',
                            "lat": '{{$user->del_lat}}',
                            "lng": '{{$user->del_lng}}',
                            "ordersRunning": 
                                @if(count($user->orders_running) > 0)
                                    [
                                        @foreach($user->orders_running as $orders)
                                            {
                                                "orderID": '{{ $orders->order_id }}',
                                                "uniqueOrderID": '{{ $orders->unique_order_id }}',
                                                "orderStatus": '{{ $orders->order_status }}',
                                                "customerLat": '{{ $orders->location['lat'] }}',
                                                "customerLng": '{{ $orders->location['lng'] }}'
                                            },
                                        @endforeach
                                    ]
                                @else
                                    []
                                @endif
                                
                        },
                    @endif
                @endforeach
                ]
            };
    
        @if(count($users) != 0)
            const centerLocation = { lat: {{$users[0]->del_lat}}, lng: {{$users[0]->del_lng}} }
        @else
            const centerLocation = { lat: 26.223227, lng: 50.201027 }
        @endif
        
        //const centerLocation = { lat:  26.223227, lng: 50.201027  }
    
        // Initialize and add the map
        function initMap() {
          
            const map = new google.maps.Map(document.getElementById("map"), {
                zoom: 10,
                center: centerLocation,
              });
              
            var informacion = new google.maps.InfoWindow();
            
            for (var i = 0; i < data.markers.length; i++) {
                var userData = data.markers[i];
                var orders = '';
                var userIcon = '';
                if(userData.deliveryStatus == 'Free') {
                    userIcon = '/assets/img/verde.png';
                } else {
                    userIcon = '/assets/img/rojo.png';
                }
                
                var userLatLng = new google.maps.LatLng(userData.lat, userData.lng);
                var marker = new google.maps.Marker({
                    position: userLatLng,
                    icon: userIcon,
                    map: map,
                    title: data.markers[i].name
                });
                var ordersLength = userData.ordersRunning.length;
                
                if(ordersLength > 0) {
                    var orderList = '';
                    for(var j = 0; j < ordersLength; j++) {
                        var orderData = userData.ordersRunning[j];
                        orderList += '<p><span><b>' + (1 + j) + ') Orden#:</b></span> <a href="https://Chatbot/tracklink/' + orderData.orderID + '" target="_blank">' + orderData.uniqueOrderID + '  &#129133;</a></p><p><span><b>Estado:</b></span> ' + orderData.orderStatus + '</p><hr>';
                    }
                    orders += '<p><span><b>Ordenes en curso (' + ordersLength + '):</b></span></p><hr>' + orderList;
                }
                
                (function (marker, userData, orders) {
                    google.maps.event.addListener(marker, "click", function (e) {
                        informacion.setContent(
                        '<p><span><b>Rider:</b></span> ' + userData.name + '</p>' + 
                        '<p><span><b>Phone:</b></span> <a href="tel:' + userData.phone + '">' + userData.phone + '</a></p>' + 
                        orders
                        );
                        informacion.open(map, marker);
                    });
                }) (marker, userData, orders);
            }
        
        }
    </script>
    
    <div class="card">
        <div class="card-body">
            <div class="table-responsive">
        <div id="map"></div>
        <script
          src="https://maps.googleapis.com/maps/api/js?key=AIzaSyCyzpSIBGzk0RRbNZN_4TxyxT-lK_xjk2k&callback=initMap&libraries=&v=weekly"
          async
        ></script>
    </div>
        </div>
    </div>
</div>

@endsection