@extends('admin.layouts.master')
@section('content')
    <div class="page-header-content header-elements-md-inline">
        <div class="page-title d-flex">
            <h4>
                <span class="font-weight-bold mr-2">Module</span>
                <i class="icon-circle-right2 mr-2"></i>
                <span class="font-weight-bold mr-2">Addons Pro</span>
            </h4>
            <a href="#" class="header-elements-toggle text-default d-md-none"><i class="icon-more"></i></a>
        </div>
        <div class="header-elements d-none py-0 mb-3 mb-md-0">
            <div class="breadcrumb">

            </div>
        </div>
    </div>

    <div class="content">
        <div class="card">
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table">
                        <tbody>
                            <tr>
                                <td><strong>Database Addon Fields</strong></td>
                                <td>Checks if new fields have been added</td>
                                <td class="text-center">
                                    @if($new_fields)
                                        <span class="badge badge-success border-grey-800 text-white text-capitalize" style="min-width: 100px;"><i class="icon-database-check mr-1"></i> Configured </span>
                                    @else
                                        <span class="badge badge-flat border-grey-800 text-default text-capitalize" style="min-width: 100px;"><i class="icon-database-remove mr-1"></i> Not Configured </span>
                                    @endif
                                </td>
                            </tr>
                            <tr>
                                <td><strong>Translations</strong></td>
                                <td>Access the menu Settings > Translations > Edit and translate the module</td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            </div>
            @isset($version)
                <div class="card-footer">
                    <div class="version">
                        v{{ $version }}
                    </div>
                </div>
            @endif
        </div>
    </div>
    <script>

    </script>
@endsection
